---
title: Overview · Cloudflare bot solutions docs
description: While Cloudflare offers several products that relate to bot
  traffic, this section reviews our bot-specific products, Bot Fight Mode, Super
  Bot Fight Mode, and Bot Management for Enterprise.
lastUpdated: 2025-09-22T16:52:07.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/bots/
  md: https://developers.cloudflare.com/bots/index.md
---

Identify and mitigate automated traffic to protect your domain from bad bots.

Available on all plans

While Cloudflare offers several products that relate to bot traffic, this section reviews our bot-specific products, Bot Fight Mode, Super Bot Fight Mode, and Bot Management for Enterprise.

Note

Enterprise customers can preview this product as a [non-contract service](https://developers.cloudflare.com/billing/preview-services/), which provides full access, free of metered usage fees, limits, and certain other restrictions.

## Which bot solution do I need?

If you have a smaller domain and have identified a bot problem, we recommend Bot Fight Mode or Super Bot Fight Mode, which are included with your plan subscription. You can enable either from your dashboard, but these solutions offer limited configuration options.

If you have a large domain with a lot of traffic, we recommend Bot Management for Enterprise, especially for customers in ecommerce, banking, and security. To enable Bot Management for Enterprise and write rules to customize your bot protection, contact your account team.

To see the differences in features and functionality, visit [Plans](https://developers.cloudflare.com/bots/plans/).

## Features

### Bot Fight Mode

Detect and mitigate bot traffic on your domain.

[Use Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/bot-fight-mode/)

### Super Bot Fight Mode

Identify traffic matching patterns of known bots, challenge or block bots, protect static resources, and view analytics to help you understand bot traffic using Super Bot Fight Mode.

[Use Super Bot Fight Mode](https://developers.cloudflare.com/bots/get-started/super-bot-fight-mode/)

### Bot Analytics

Use Bot Analytics to dynamically examine bot traffic.

[Use Bot Analytics](https://developers.cloudflare.com/bots/bot-analytics/)

### Firewall variables

Access several new variables within the Firewall expression builder.

[Use Firewall variables](https://developers.cloudflare.com/bots/reference/bot-management-variables/)

## Related products

**[API Shield](https://developers.cloudflare.com/api-shield/)**

Identify and address API vulnerabilities using API Shield.

**[DDoS Protection](https://developers.cloudflare.com/ddos-protection/)**

Detect and mitigate Distributed Denial of Service (DDoS) attacks using Cloudflare's Autonomous Edge.

**[Turnstile](https://developers.cloudflare.com/turnstile/)**

Use Cloudflare's smart CAPTCHA alternative to run less intrusive challenges.

**[WAF](https://developers.cloudflare.com/waf/)**

Get automatic protection from vulnerabilities and the flexibility to create custom rules.

## More resources

[Plans](https://www.cloudflare.com/plans/#overview)

Compare available Cloudflare plans
