---
title: DNS records · Cloudflare One docs
description: When you create a tunnel, Cloudflare generates a subdomain of
  cfargotunnel.com with the UUID of the created tunnel. You can treat
  <UUID>.cfargotunnel.com as if it were an origin target in the Cloudflare
  dashboard.
lastUpdated: 2025-10-21T14:33:19.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/dns/
  md: https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/routing-to-tunnel/dns/index.md
---

When you create a tunnel, Cloudflare generates a subdomain of `cfargotunnel.com` with the UUID of the created tunnel. You can treat `<UUID>.cfargotunnel.com` as if it were an origin target in the Cloudflare dashboard.

Unlike publicly routable IP addresses, `<UUID>.cfargotunnel.com` will only proxy traffic for a DNS record in the same Cloudflare account. The Tunnel UUID is not secret information; if someone discovers your subdomain UUID, they will not be able to create a DNS record in another account or system to proxy traffic to the address.

## Create a DNS record for the tunnel

* Dashboard

  To create a new DNS record for your tunnel:

  1. Log in to the [Cloudflare dashboard](https://dash.cloudflare.com/) and go to the **DNS Records** page for your domain.

     [Go to **Records**](https://dash.cloudflare.com/?to=/:account/:zone/dns/records)

  2. Select **Add record**.

  3. Input the following information:

     * **Type**: *CNAME*
     * **Name**: Subdomain of your application
     * **Target**: `<UUID>.cfargotunnel.com`

  4. Select **Save**.

  ![Example of fields completed to create a new CNAME record.](https://developers.cloudflare.com/_astro/dns-record.B25etJTI_niW2V.webp)

* cli

  You can create a new DNS record directly from `cloudflared`:

  ```sh
  cloudflared tunnel route dns <UUID or NAME> www.app.com
  ```

  This command create a `CNAME` record that points to the tunnel subdomain, but will not proxy traffic if the tunnel is not currently running.

  Note

  To create DNS records using `cloudflared`, the [`cert.pem`](https://developers.cloudflare.com/cloudflare-one/networks/connectors/cloudflare-tunnel/do-more-with-tunnels/local-management/local-tunnel-terms/#certpem) file must be installed on your system.

The DNS record is distinct from the state of the tunnel. You can create DNS records that point to a tunnel that is not currently running. If the tunnel stops running, the DNS record will not be deleted. If you point the DNS record to a tunnel not currently running, visitors will see a `1016` error message.

Additionally, you can create multiple DNS records that point to the same tunnel subdomain. If you are routing traffic from multiple hostnames to multiple services, you will need to create a `CNAME` entry for each hostname. The CNAME entries will share the same target.

## Optional Cloudflare settings

The application will default to the Cloudflare settings of the hostname in your account that includes the Cloudflare Tunnel DNS record, including [cache rules](https://developers.cloudflare.com/cache/how-to/cache-rules/) and [firewall policies](https://developers.cloudflare.com/firewall/). You can changes these settings for your hostname in Cloudflare's dashboard.
