---
title: WARP sessions · Cloudflare One docs
description: Cloudflare Zero Trust enforces WARP client reauthentication on a
  per-application basis, unlike legacy VPNs which treat it as a global setting.
  You can configure WARP session timeouts for your Access applications or as
  part of your Gateway policies.
lastUpdated: 2025-10-24T20:47:24.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/
  md: https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-sessions/index.md
---

Cloudflare Zero Trust enforces WARP client reauthentication on a per-application basis, unlike legacy VPNs which treat it as a global setting. You can configure WARP session timeouts for your [Access applications](#configure-warp-sessions-in-access) or as part of your [Gateway policies](#configure-warp-sessions-in-gateway).

When a user goes to a protected application or website, Cloudflare checks their WARP session duration against the configured session timeout. If the session has expired, the user will be prompted to re-authenticate with the identity provider (IdP) used to enroll in the WARP client.

![WARP client prompts user to re-authenticate session.](https://developers.cloudflare.com/_astro/warp-reauthenticate-session.BjGtdKWz_ZIudhz.webp)

A user's WARP session duration resets to zero whenever they re-authenticate with the IdP, regardless of what triggered the authentication event.

## Prerequisites

Ensure that traffic can reach your IdP and `<your-team-name>.cloudflareaccess.com` through WARP.

## Configure WARP sessions in Gateway

You can enforce WARP session timeouts on any Gateway Network and HTTP policy that has an Allow action. If you do not specify a session timeout, the WARP session will be unlimited by default.

Session timeouts have no impact on Gateway DNS policies. DNS policies remain active even when a user needs to re-authenticate.

To configure a session timeout for a Gateway policy:

* Dashboard

  1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to either **Traffic policies** > **Firewall policies**. Choose either **Network** or **HTTP**.
  2. Add a policy and select the *Allow* action. Alternatively, choose any existing *Allow* policy.
  3. Under **Step 4 - Configure policy settings**, select **Edit** next to **Enforce WARP client session duration**.
  4. Enter a session expiration time in `1h30m0s` format and save.
  5. Save the policy.

* Terraform (v5)

  1. Add the following permission to your [`cloudflare_api_token`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/api_token):

     * `Zero Trust Write`

  2. Choose a Network (`l4`) or HTTP (`http`) policy with an Allow action.

  3. In the policy's [`rule_settings`](https://registry.terraform.io/providers/cloudflare/cloudflare/latest/docs/resources/zero_trust_gateway_policy), use the `check_session` argument to enable and configure a session timeout:

     ```tf
     resource "cloudflare_zero_trust_gateway_policy" "network_allow_wiki_IPs" {
       name        = "Company Wiki Network policy"
       enabled     = true
       account_id  = var.cloudflare_account_id
       description = "Managed by Terraform - Allow employees to access company wiki IPs."
       precedence  = 103
       action      = "allow"
       filters     = ["l4"]
       traffic     = "net.dst.ip in ${"$"}${cloudflare_zero_trust_list.wiki_IPs.id}"
       identity    = "identity.email matches \".*@example.com\""


       rule_settings = {
         check_session = {
           enforce = true
           duration = "1h30m0s"
         }
       }
     }
     ```

Session checks are now enabled for the application protected by this policy. Users can continue to reach applications outside of the policy definition.

Enforce a global timeout

To enforce a global reauthentication event, set each of your Network or HTTP policies to the same WARP session duration.

## Configure WARP sessions in Access Beta

You can allow users to log in to Access applications using their WARP session. WARP authentication is only supported for Access applications protected by Allow or Block policies.

To configure WARP sessions for Access applications:

1. In [Cloudflare One](https://one.dash.cloudflare.com/), go to **Team & Resources** > **Devices** > **Management**.
2. In **Device enrollment permissions**, select **Manage**.
3. Go to the **Login methods** tab and enable **WARP authentication identity**.
4. Under **Session duration**, choose a session timeout value. This timeout will apply to all Access applications that have WARP authentication enabled.

Note

This timeout value does not apply to [WARP session checks in Gateway policies](#configure-warp-sessions-in-gateway).

1. (Optional) To enable WARP authentication by default for all existing and new applications, select **Apply to all Access applications**. You can override this default setting on a per-application basis when you [create](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/) or modify an Access application.
2. Select **Save**.

Users can now authenticate once with WARP and have access to your Access applications for the configured period of time. The session timer resets when the user re-authenticates with the IdP used to enroll in WARP.

## Force user interaction with IdP

If the user has an active browser session with the IdP, WARP will use the existing browser cookies to re-authenticate and the user will not be prompted to re-enter their credentials. You can override this behavior to require explicit user interaction in the IdP.

### Supported IdPs

* [Microsoft Entra ID](https://developers.cloudflare.com/cloudflare-one/integrations/identity-providers/entra-id/#force-user-interaction-during-warp-reauthentication)

## Manually reauthenticate

To manually refresh your Cloudflare Access session and update your group information from your identity provider (IdP), go to the following URL in your browser and fill in your [team name](https://developers.cloudflare.com/cloudflare-one/faq/getting-started-faq/#what-is-a-team-domainteam-name):

`https://<your-team-name>.cloudflareaccess.com/cdn-cgi/access/refresh-identity`

Reauthenticating resets your [session duration](https://developers.cloudflare.com/cloudflare-one/access-controls/access-settings/session-management/) and fetches the latest group information from the organization's IdP.

## Limitations

* **Only one user per device** — If a device is already registered with User A, User B will not be able to log in on that device through the re-authentication flow. To switch the device registration to a different user, User A must first log out from Zero Trust (if [Allow device to leave organization](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/configure-warp/warp-settings/#allow-device-to-leave-organization) is enabled), or an admin can revoke the registration from **My Team** > **Devices**. User B can then properly [enroll](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/deployment/manual-deployment/).
* **Active connections are not terminated** — Active sessions such as SSH and RDP will remain connected beyond the timeout limit.
* **Binding Cookie is not supported** - WARP authentication will not work for Access applications that have the [Binding Cookie](https://developers.cloudflare.com/cloudflare-one/access-controls/applications/http-apps/authorization-cookie/#binding-cookie) enabled.

## Related resources

* [Connectivity status](https://developers.cloudflare.com/cloudflare-one/team-and-resources/devices/warp/troubleshooting/connectivity-status/) - Learn about the status messages displayed by the WARP client during its connection process, and understand each stage as WARP establishes a secure tunnel to Cloudflare.
