---
title: Available fields and functions · Cloudflare Rules docs
description: "The available fields when setting an HTTP request header value
  using an expression are the following:"
lastUpdated: 2025-08-22T14:24:45.000Z
chatbotDeprioritize: false
source_url:
  html: https://developers.cloudflare.com/rules/transform/request-header-modification/reference/fields-functions/
  md: https://developers.cloudflare.com/rules/transform/request-header-modification/reference/fields-functions/index.md
---

The available fields when setting an HTTP request header value using an expression are the following:

* `cf.bot_management.*`
* `cf.bot_detection.js_check_score`
* `cf.client.bot`
* `cf.threat_score`
* `cf.verified_bot_category`
* `cf.edge.server_ip`
* `cf.edge.server_port`
* `cf.edge.client_port`
* `cf.hostname.metadata`
* `cf.zone.name`
* `cf.metal.id`
* `cf.random_seed`
* `cf.ray_id`
* `cf.tls_version`
* `cf.tls_cipher`
* `cf.tls_client_hello_length`
* `cf.tls_client_random`
* `cf.tls_client_extensions_sha1`
* `cf.tls_client_extensions_sha1_le`
* `cf.tls_client_ciphers_sha1`
* `cf.tls_client_auth.*`
* `http.cookie`
* `http.host`
* `http.referer`
* `http.request.headers`
* `http.request.headers.*`
* `http.request.accepted_languages`
* `http.request.method`
* `http.request.timestamp.sec`
* `http.request.timestamp.msec`
* `http.request.full_uri`
* `http.request.uri`
* `http.request.uri.*`
* `http.request.version`
* `raw.http.request.full_uri`
* `raw.http.request.uri`
* `raw.http.request.uri.*`
* `raw.http.request.headers`
* `raw.http.request.headers.*`
* `http.user_agent`
* `http.x_forwarded_for`
* `ip.src`
* `ip.src.lat`
* `ip.src.lon`
* `ip.src.asnum`
* `ip.src.city`
* `ip.src.country`
* `ip.src.continent`
* `ip.src.metro_code`
* `ip.src.postal_code`
* `ip.src.region`
* `ip.src.region_code`
* `ip.src.is_in_european_union`
* `ip.src.subdivision_1_iso_code`
* `ip.src.subdivision_2_iso_code`
* `ssl`

- `http.request.jwt.claims`
- `http.request.jwt.claims.*`
- `cf.sequence.current_op`
- `cf.sequence.msec_since_op`
- `cf.sequence.previous_ops`
- `cf.waf.auth_detected`
- `cf.waf.credential_check.*`
- `cf.waf.score`
- `cf.waf.score.*`
- `cf.worker.upstream_zone`

Refer to [Fields](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/) for reference information on these fields.

Important

* To obtain the value of an HTTP header using the [`http.request.headers`](https://developers.cloudflare.com/ruleset-engine/rules-language/fields/reference/http.request.headers/) field, specify the header name in **lowercase**. For example, to get the first value of the `Accept-Encoding` request header in an expression, use: `http.request.headers["accept-encoding"][0]`.

* Use the `to_string()` function to get the string representation of a non-string value like an Integer value. For example, `to_string(cf.bot_management.score)`.

For information on the available functions, refer to [Functions](https://developers.cloudflare.com/ruleset-engine/rules-language/functions/).
